// shopbot.h ackmed@gotwalls.com
#pragma once
#include "item.h"
#include "config.h"
#include "external/D2Hackit.h"
#include "external/D2Client.h"

// defines
#define VERSION_MAJOR		0
#define VERSION_MINOR		50

// different states the bot can be in
#define STATE_NONE				0x00	// bot not going
#define STATE_ANTIIDLE			0x01	// anti idle mode.

#define	STATE_WALKNPC_START		0x02
#define STATE_WALKNPC			0x03
#define STATE_WALKWP_START		0x04
#define STATE_WALKWP			0x05

#define STATE_OPENSTORE			0x06
#define STATE_CLOSESTORE		0x07

#define STATE_WPTOTOWN			0x08	// taking wp to town
#define STATE_WPFROMTOWN		0x09	// taking wp to loc out of town
#define STATE_OPENWPTOTOWN		0x0A	// taking wp to town
#define STATE_OPENWPFROMTOWN	0x0B	// taking wp to loc out of town
#define STATE_MAKESUREOPENSTORE	0x0C
#define STATE_RECIEVEITEMS		0x0D
#define STATE_WALKCLOSERTONPC	0x0E
#define STATE_WALKCLOSERTOWP	0x0F
#define STATE_BROWSE			0x10
#define STATE_BUYITEMS			0x11
#define STATE_BUYITEMSWAIT		0x12
#define STATE_BUYERROR			0x13
#define STATE_BUYGOOD			0x14



// global vars
extern char DebugBuffer[1024];
extern WORD state;


// functions
BOOL PRIVATE OnCommandRecord(char **argv, int argc);
BOOL PRIVATE OnCommandClear(char **argv, int argc);
BOOL PRIVATE OnCommandSetNPC(char **argv, int argc);
BOOL PRIVATE OnCommandHelp(char** argv, int argc);
BOOL PRIVATE OnCommandReload(char **argv, int argc);
BOOL PRIVATE OnCommandStart(char **argv, int argc);
BOOL PRIVATE OnCommandStop(char **argv, int argc);
BOOL PRIVATE OnCommandSavePath(char **argv, int argc);
BOOL PRIVATE OnCommandLoadPath(char **argv, int argc);
BOOL PRIVATE OnCommandTownWP(char **argv, int argc);
BOOL PRIVATE OnCommandOtherWP(char **argv, int argc);
BOOL PRIVATE OnCommandBrowse(char **argv, int argc);
BOOL PRIVATE OnCommandLoadConfig(char **argv, int argc);

BOOL LoadConfig(char* configname);
CONFIGSTRUCT* ItemMatchCheck(ITEMSTRUCT *item);
void SetNPCLid(int actNum, char *npcName);
void ListNPC(int actNum);

